/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.ColorCalculators.RayMarching;

public class Vector {
    public double x;
    public double y;
    public double z;
    public double val = 1.0;
    private double magnitude;
    private boolean magChanged;

    public Vector(double x, double y, double z, double val) {
        this.val = val;
        this.x = x;
        this.y = y;
        this.z = z;
        this.magChanged = true;
    }

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.magChanged = true;
    }

    public Vector(double x, double y) {
        this.x = x;
        this.y = y;
        this.z = 0.0;
        this.magChanged = true;
    }

    public Vector add(Vector o) {
        Vector out = new Vector(this.x, this.y, this.z);
        out.x += o.x;
        out.y += o.y;
        out.z += o.z;
        this.magChanged = true;
        return out;
    }

    public Vector sub(Vector o) {
        Vector out = new Vector(this.x, this.y, this.z);
        out.x -= o.x;
        out.y -= o.y;
        out.z -= o.z;
        this.magChanged = true;
        return out;
    }

    public double dot(Vector o) {
        return this.x * o.x + this.y * o.y + this.z * o.z;
    }

    public Vector mult(double in) {
        Vector out = new Vector(this.x, this.y, this.z);
        out.x *= in;
        out.y *= in;
        out.z *= in;
        out.magnitude = this.mag() * in;
        out.magChanged = false;
        return out;
    }

    public Vector div(double in) {
        Vector out = new Vector(this.x, this.y, this.z);
        out.x /= in;
        out.y /= in;
        out.z /= in;
        out.magnitude = this.mag() / in;
        out.magChanged = false;
        return out;
    }

    public Vector cross(Vector o) {
        return new Vector(this.y * o.z - this.z * o.y, this.z * o.x - this.x * o.z, this.x * o.y - this.y * o.x);
    }

    public double mag() {
        if (this.magChanged) {
            this.magnitude = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            this.magChanged = false;
        }
        return this.magnitude;
    }

    public Vector norm() {
        if (!this.magChanged && this.magnitude == 1.0) {
            return this;
        }
        Vector out = this.div(this.mag());
        out.magnitude = 1.0;
        return out;
    }

    public Vector reflection(Vector normal) {
        return this.sub(normal.mult(2.0).mult(this.dot(normal)));
    }

    public void setMagnitude(double m) {
        this.magChanged = false;
        this.magnitude = m;
    }

    public Vector proj(Vector b) {
        return b.mult(this.dot(b) / b.dot(b));
    }

    public boolean equals(Vector in) {
        return this.x == in.x && this.y == in.y && this.z == in.z;
    }

    public String toString() {
        return "X = " + this.x + " Y = " + this.y + " Z = " + this.z;
    }
}

